/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStatesMap<V>
implements Map<BlockState, V> {
    protected final Map<Block, V> blocksWithAllStates = new ConcurrentHashMap<Block, V>();
    protected final Map<Block, Map<BlockState, V>> blockStatesMap = new ConcurrentHashMap<Block, Map<BlockState, V>>();
    protected boolean sizeChanged = false;
    protected int size = 0;
    protected Set<BlockState> keySet;
    protected Collection<V> values;
    protected Set<Map.Entry<BlockState, V>> entrySet;

    public static BlockStatesMap<BlockState> parseReplacementsFrom(String[] strArray) {
        BlockStatesMap<BlockState> replacements = new BlockStatesMap<BlockState>();
        for (String str : strArray) {
            boolean error;
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split("->");
            boolean bl = error = split.length < 2;
            if (!error) {
                BlockState replacement;
                UnitId source = UnitId.from(split[0].trim());
                UnitId dest = UnitId.from(split[1].trim());
                boolean bl2 = error = source.isEmpty() || dest.isEmpty();
                if (!error && (replacement = dest.getFirstMatchedState()) != null) {
                    replacements.put(source, replacement);
                }
            }
            if (!error) continue;
            ForgeEndertech.getInstance().getLogger().error("Unable to parse replacement from " + CommonString.doubleQuoted(str));
        }
        return replacements;
    }

    @Override
    public int size() {
        if (this.sizeChanged) {
            this.size = 0;
            EntryIterator iter = new EntryIterator();
            while (iter.hasNext()) {
                iter.next();
                ++this.size;
            }
            this.sizeChanged = false;
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.blocksWithAllStates.isEmpty() && this.blockStatesMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Block) {
            if (this.blocksWithAllStates.containsKey(key)) {
                return true;
            }
            Map<BlockState, V> map = this.blockStatesMap.get(key);
            return map != null && !map.isEmpty();
        }
        if (key instanceof BlockState) {
            Block block = ((BlockState)key).m_60734_();
            if (this.blocksWithAllStates.containsKey(block)) {
                return true;
            }
            Map<BlockState, V> map = this.blockStatesMap.get(block);
            return map != null && map.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.blocksWithAllStates.containsValue(value)) {
            return true;
        }
        EntryIterator iter = new EntryIterator();
        while (iter.hasNext()) {
            if (!iter.next().getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Map<Block, V> getBlocksWithAllStates() {
        return this.blocksWithAllStates;
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (key instanceof Block) {
            return this.blocksWithAllStates.get(key);
        }
        if (key instanceof BlockState) {
            V value;
            Block block = ((BlockState)key).m_60734_();
            Map<BlockState, V> map = this.blockStatesMap.get(block);
            if (map != null && (value = map.get(key)) != null) {
                return value;
            }
            return this.blocksWithAllStates.get(block);
        }
        return null;
    }

    @Override
    public V put(BlockState state, V value) {
        V previous;
        Map<BlockState, V> map = this.blockStatesMap.get(state.m_60734_());
        if (map == null) {
            map = this.createNewStateMapFor(state.m_60734_());
        }
        if ((previous = map.put(state, value)) != null) {
            this.sizeChanged = true;
        }
        return previous;
    }

    @Override
    public void put(UnitId id, V value) {
        BlockStatesSet set = id.getAllMatchedBlockStates();
        if (set != null) {
            set.getBlocksWithAllStates().forEach((? super T block) -> this.getBlocksWithAllStates().put((Block)block, value));
            set.forEach((? super T state) -> this.put((BlockState)state, value));
        }
    }

    protected Map<BlockState, V> createNewStateMapFor(Block block) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.blockStatesMap.put(block, map);
        return map;
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Block) {
            V prev = this.blocksWithAllStates.remove(key);
            Map<BlockState, V> prevMap = this.blockStatesMap.remove(key);
            if (prev != null) {
                return prev;
            }
            if (prevMap != null) {
                return prevMap.values().stream().findFirst().orElseGet(null);
            }
        }
        V removed = null;
        if (key instanceof BlockState) {
            BlockState state = (BlockState)key;
            Map<BlockState, V> map = this.blockStatesMap.get(state.m_60734_());
            if (map != null) {
                removed = map.remove(state);
                if (map.isEmpty()) {
                    this.blockStatesMap.remove(state.m_60734_());
                }
            }
            if (removed != null) {
                this.sizeChanged = true;
            }
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends BlockState, ? extends V> m) {
        if (m instanceof BlockStatesMap) {
            this.blocksWithAllStates.putAll(((BlockStatesMap)m).getBlocksWithAllStates());
        }
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.blocksWithAllStates.clear();
        this.blockStatesMap.clear();
        this.sizeChanged = true;
    }

    @Override
    public Set<BlockState> keySet() {
        EntrySet<BlockState> ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new EntrySet<BlockState>(){

                @Override
                public Iterator<BlockState> iterator() {
                    return new Iterator<BlockState>(){
                        final Iterator<Map.Entry<BlockState, V>> iter;
                        {
                            this.iter = new EntryIterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iter.hasNext();
                        }

                        @Override
                        public BlockState next() {
                            return this.iter.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.iter.remove();
                        }
                    };
                }
            };
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        EntrySet vals = this.values;
        if (vals == null) {
            this.values = vals = new EntrySet<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final EntryIterator iter;
                        {
                            this.iter = new EntryIterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iter.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.iter.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.iter.remove();
                        }
                    };
                }
            };
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<BlockState, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet<Map.Entry<BlockState, V>>(){

                @Override
                public Iterator<Map.Entry<BlockState, V>> iterator() {
                    return new EntryIterator();
                }
            };
        }
        return es;
    }

    protected class EntryIterator
    implements Iterator<Map.Entry<BlockState, V>> {
        protected final Iterator<Map<BlockState, V>> outter;
        protected Iterator<Map.Entry<BlockState, V>> inner;

        protected EntryIterator() {
            this.outter = BlockStatesMap.this.blockStatesMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.inner != null && this.inner.hasNext()) {
                return true;
            }
            while (this.outter.hasNext()) {
                this.inner = this.outter.next().entrySet().iterator();
                if (!this.inner.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<BlockState, V> next() {
            return this.inner.next();
        }

        @Override
        public void remove() {
            this.inner.remove();
            BlockStatesMap.this.sizeChanged = true;
        }
    }

    protected abstract class EntrySet<E>
    extends AbstractSet<E> {
        protected EntrySet() {
        }

        @Override
        public int size() {
            return BlockStatesMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BlockStatesMap.this.isEmpty();
        }

        @Override
        public void clear() {
            BlockStatesMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return BlockStatesMap.this.containsKey(o);
        }
    }
}

